package ru.yandex.direct.useractionlog.writer.generator;

import java.util.Collection;
import java.util.Collections;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.binlog.reader.EnrichedRow;
import ru.yandex.direct.binlog.reader.MySQLSimpleRowIndexed;
import ru.yandex.direct.useractionlog.ClientId;
import ru.yandex.direct.useractionlog.dict.DictDataCategory;
import ru.yandex.direct.useractionlog.dict.DictResponsesAccessor;
import ru.yandex.direct.useractionlog.dict.FreshDictValuesFiller;
import ru.yandex.direct.useractionlog.schema.ObjectPath;

import static ru.yandex.direct.dbschema.ppc.tables.Clients.CLIENTS;

/**
 * Специализируется на таблицах, в которых первичный ключ - идентификатор клиента. Например, ppc.clients.
 */
@ParametersAreNonnullByDefault
class ClientPathStrategy implements ObjectPathStrategy {
    @Override
    public Collection<String> objectPathColumns() {
        return Collections.singletonList(CLIENTS.CLIENT_ID.getName());
    }

    @Override
    public ObjectPath extract(EnrichedRow row, DictResponsesAccessor dictResponsesAccessor) {
        MySQLSimpleRowIndexed fields = Util.dataForGettingId(row);
        return new ObjectPath.ClientPath(new ClientId(fields.getByName(CLIENTS.CLIENT_ID.getName())));
    }

    @Override
    public Collection<DictDataCategory> provides() {
        return Collections.emptyList();
    }

    @Override
    public void fillFreshDictValues(EnrichedRow row, DictResponsesAccessor dictData,
                                    FreshDictValuesFiller freshDictValues) {
        // Значение содержало бы то же самое, что уже есть в ключе. Нет смысла в таких словарных данных.
    }
}
