package ru.yandex.direct.useractionlog.writer.generator;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.useractionlog.schema.RecordSource;

/*
Изменения в таблице клиентов настолько редки, что делать какие-либо фильтрации полей не имеет смысла.

SELECT
table,
toString(operation),
count(*) AS cnt
FROM binlog_rows
WHERE (date = '2017-04-04') AND (db = 'ppc') AND (table IN ('clients', 'clients_options', 'campaigns', 'phrases', 'banners'))
GROUP BY
table,
operation
ORDER BY cnt DESC

┏━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━┓
┃ table           ┃ toString(operation) ┃       cnt ┃
┡━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━┩
│ banners         │ UPDATE              │ 349600232 │
├─────────────────┼─────────────────────┼───────────┤
│ phrases         │ UPDATE              │ 152532078 │
├─────────────────┼─────────────────────┼───────────┤
│ campaigns       │ UPDATE              │ 105210796 │
├─────────────────┼─────────────────────┼───────────┤
│ banners         │ INSERT              │   5771904 │
├─────────────────┼─────────────────────┼───────────┤
│ phrases         │ INSERT              │   4665555 │
├─────────────────┼─────────────────────┼───────────┤
│ banners         │ DELETE              │   2603470 │
├─────────────────┼─────────────────────┼───────────┤
│ phrases         │ DELETE              │   2348855 │
├─────────────────┼─────────────────────┼───────────┤
│ clients_options │ UPDATE              │     54963 │
├─────────────────┼─────────────────────┼───────────┤
│ campaigns       │ INSERT              │     46816 │
├─────────────────┼─────────────────────┼───────────┤
│ campaigns       │ DELETE              │     21555 │
├─────────────────┼─────────────────────┼───────────┤
│ clients         │ UPDATE              │      8651 │
├─────────────────┼─────────────────────┼───────────┤
│ clients_options │ INSERT              │      2894 │
├─────────────────┼─────────────────────┼───────────┤
│ clients         │ INSERT              │      2893 │
├─────────────────┼─────────────────────┼───────────┤
│ clients_options │ DELETE              │       237 │
├─────────────────┼─────────────────────┼───────────┤
│ clients         │ DELETE              │       235 │
└─────────────────┴─────────────────────┴───────────┘
*/
@ParametersAreNonnullByDefault
class ClientRowProcessingStrategy extends ModularRowProcessingStrategy {
    ClientRowProcessingStrategy(RecordSource recordSource) {
        super(recordSource, new ClientPathStrategy(), DeduplicationFieldsStrategy.builder().build());
    }
}
