package ru.yandex.direct.useractionlog.writer.generator;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.binlog.reader.EnrichedRow;
import ru.yandex.direct.useractionlog.dict.DictDataCategory;
import ru.yandex.direct.useractionlog.dict.DictResponsesAccessor;
import ru.yandex.direct.useractionlog.dict.FreshDictValuesFiller;

/**
 * Интерфейс для классов, которые предоставляют новые словарные данные.
 * <p>
 * См. также {@link DictRequester}.
 */
@ParametersAreNonnullByDefault
public interface DictFiller extends DictRequester {
    /**
     * Добавить новые словарные данные. Если добавляемые данные уже известны, то ничего не произойдёт.
     * <p>
     * Метод не имеет default-реализации специально для того, чтобы разработчик не забыл перечислить генерируемые
     * категории словарных данных. Такой логический баг будет сложно найти.
     *
     * @param row             Событие о создании/изменении/удалении строки в таблице.
     * @param dictData        Словарные данные, запрошенные ранее.
     * @param freshDictValues Объект для добавления новых словарных данных.
     */
    void fillFreshDictValues(EnrichedRow row, DictResponsesAccessor dictData, FreshDictValuesFiller freshDictValues);

    /**
     * Какие категории словарных данных могут быть созданы в
     * {@link #fillFreshDictValues(EnrichedRow, DictResponsesAccessor, FreshDictValuesFiller)}.
     * <p>
     * Метод не имеет default-реализации специально для того, чтобы разработчик не забыл перечислить генерируемые
     * категории словарных данных. Такой логический баг будет сложно найти. Если никакие новые словарные данные не
     * создаются, то следует вернуть пустую коллекцию.
     */
    Collection<DictDataCategory> provides();
}
