package ru.yandex.direct.useractionlog.writer.generator;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;

import ru.yandex.direct.binlog.reader.EnrichedRow;
import ru.yandex.direct.useractionlog.dict.DictDataCategory;
import ru.yandex.direct.useractionlog.dict.DictRequestsFiller;
import ru.yandex.direct.useractionlog.dict.DictResponsesAccessor;
import ru.yandex.direct.useractionlog.dict.FreshDictValuesFiller;

/**
 * Комбинация нескольких экземпляров {@link DictFiller}.
 */
@ParametersAreNonnullByDefault
public class DictFillerChain implements DictFiller {
    private final ImmutableList<DictFiller> chain;

    public DictFillerChain(ImmutableList<DictFiller> chain) {
        this.chain = chain;
    }

    public DictFillerChain(DictFiller... chain) {
        this(ImmutableList.copyOf(chain));
    }

    @Override
    public void fillDictRequests(EnrichedRow row, DictRequestsFiller dictRequests) {
        for (DictFiller filler : chain) {
            filler.fillDictRequests(row, dictRequests);
        }
    }

    @Override
    public Collection<DictDataCategory> provides() {
        ImmutableSet.Builder<DictDataCategory> builder = ImmutableSet.builder();
        for (DictFiller filler : chain) {
            builder.addAll(filler.provides());
        }
        return builder.build();
    }

    @Override
    public void fillFreshDictValues(EnrichedRow row, DictResponsesAccessor dictData,
                                    FreshDictValuesFiller freshDictValues) {
        for (DictFiller filler : chain) {
            filler.fillFreshDictValues(row, dictData, freshDictValues);
        }
    }
}
