package ru.yandex.direct.useractionlog.writer.generator;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;

import ru.yandex.direct.binlog.reader.EnrichedRow;
import ru.yandex.direct.useractionlog.dict.DictDataCategory;
import ru.yandex.direct.useractionlog.dict.DictRequestsFiller;
import ru.yandex.direct.useractionlog.dict.DictResponsesAccessor;
import ru.yandex.direct.useractionlog.dict.FreshDictValuesFiller;

/**
 * По названию таблицы выбирает один из {@link DictFiller} и вызывает у него соответствующие методы.
 */
@ParametersAreNonnullByDefault
public class DictFillerTableSwitch implements DictFiller {
    private final ImmutableMap<String, DictFiller> byTableName;
    private final ImmutableSet<DictDataCategory> providesCategories;

    /**
     * @param byTableName Соответствие названия таблицы и обработчика для этой таблицы.
     */
    DictFillerTableSwitch(ImmutableMap<String, DictFiller> byTableName) {
        this.byTableName = byTableName;
        ImmutableSet.Builder<DictDataCategory> categories = ImmutableSet.builder();
        for (DictFiller filler : byTableName.values()) {
            categories.addAll(filler.provides());
        }
        this.providesCategories = categories.build();
    }

    @Override
    public void fillDictRequests(EnrichedRow row, DictRequestsFiller dictRequests) {
        DictFiller dictFiller = byTableName.get(row.getTableName());
        if (dictFiller != null) {
            dictFiller.fillDictRequests(row, dictRequests);
        }
    }

    @Override
    public void fillFreshDictValues(EnrichedRow row, DictResponsesAccessor dictData,
                                    FreshDictValuesFiller freshDictValues) {
        DictFiller dictFiller = byTableName.get(row.getTableName());
        if (dictFiller != null) {
            dictFiller.fillFreshDictValues(row, dictData, freshDictValues);
        }
    }

    @Override
    public Collection<DictDataCategory> provides() {
        return providesCategories;
    }

    public ImmutableSet<String> getTableNames() {
        return byTableName.keySet();
    }
}
