package ru.yandex.direct.useractionlog.writer.generator;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.binlog.reader.EnrichedRow;
import ru.yandex.direct.useractionlog.dict.DictRequestsFiller;

/**
 * Интерфейс для классов, которые собираются запрашивать словарные данные.
 * <p>
 * Пусть есть набор объектов, реализующий этот интерфейс, которые делают какие-то полезные вычисления и которые
 * нуждаются в словарных данных. Алгоритм работы с этим набором объектов:
 * <ul>
 * <li>
 * Для всех объектов, реализующих этот интерфейс, вызывается
 * {@link #fillDictRequests(EnrichedRow, DictRequestsFiller)}.
 * С помощью {@link DictRequestsFiller} объект-стратегия запрашивает необходимые словарные данные для генерации логов из
 * binlog-события.
 * </li>
 * <li>
 * Все запросы собираются в один список и обрабатываются одним разом.
 * </li>
 * <li>
 * Выполняются какие-либо вычисления, которые не регламентируются этим
 * интерфейсом. Доступ к полученным словарным данным будет предоставляться с помощью
 * {@link ru.yandex.direct.useractionlog.dict.DictResponsesAccessor}.
 * </li>
 * </ul>
 * Частичная реализация алгоритма (запрос и добавление словарных данных): {@link BatchRowDictProcessing}.
 */
@ParametersAreNonnullByDefault
public interface DictRequester {
    /**
     * Запросить словарные данные, необходимые для создания списков полей.
     *
     * @param row          Событие о создании/изменении/удалении строки в таблице.
     * @param dictRequests Объект для хранения запросов к словарным данным.
     */
    default void fillDictRequests(EnrichedRow row, DictRequestsFiller dictRequests) {
    }
}
