package ru.yandex.direct.useractionlog.writer.generator;

import java.util.Collection;
import java.util.Collections;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.binlog.reader.EnrichedRow;
import ru.yandex.direct.useractionlog.dict.DictDataCategory;
import ru.yandex.direct.useractionlog.dict.DictResponsesAccessor;
import ru.yandex.direct.useractionlog.dict.FreshDictValuesFiller;

/**
 * {@link DictFiller}, который не делает ничего. Используется в качестве заглушки.
 */
@ParametersAreNonnullByDefault
class DummyFiller implements DictFiller, PureDictFillerFactory {
    /**
     * Так как этот объект не имеет никакого состояния, рекомендуется везде, где это возможно, использовать один общий
     * экземпляр класса вместо того, чтобы создавать множество экземпляров.
     */
    static final DummyFiller INSTANCE = new DummyFiller();

    @Override
    public void fillFreshDictValues(EnrichedRow row, DictResponsesAccessor dictData,
                                    FreshDictValuesFiller freshDictValues) {
        // Этот класс специально создан, чтобы ничего не делать
    }

    @Override
    public Collection<DictDataCategory> provides() {
        return Collections.emptyList();
    }

    @Override
    public DictFiller makePureDictFiller() {
        return this;
    }
}
