package ru.yandex.direct.useractionlog.writer.generator;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableSet;

import ru.yandex.direct.useractionlog.dict.DictResponsesAccessor;
import ru.yandex.direct.useractionlog.model.RowModel;
import ru.yandex.direct.useractionlog.model.RowModelPair;

/**
 * При создании, изменении и удалении записи в таблицу выкидывает из записи заданные поля.
 */
@ParametersAreNonnullByDefault
class FilterFieldsStrategy extends DummyFiller implements FieldsStrategy {
    @Nonnull
    private final ImmutableSet<String> unwantedFields;

    /**
     * @param unwantedFields Названия колонок, значения которых не нужно записывать в пользовательские логи.
     */
    FilterFieldsStrategy(String... unwantedFields) {
        this.unwantedFields = new ImmutableSet.Builder<String>().add(unwantedFields).build();
    }

    @Override
    public void handleInsert(RowModel after, DictResponsesAccessor dictResponsesAccessor) {
        after.getMap().entrySet().removeIf(e -> unwantedFields.contains(e.getKey()));
        after.validate();
    }

    @Override
    public void handleUpdate(RowModelPair pair,
                             DictResponsesAccessor dictResponsesAccessor) {
        pair.before.getMap().entrySet().removeIf(e -> unwantedFields.contains(e.getKey()));
        pair.after.getMap().entrySet().removeIf(e -> unwantedFields.contains(e.getKey()));
        pair.validate();
    }

    @Override
    public void handleDelete(RowModel before, DictResponsesAccessor dictResponsesAccessor) {
        before.getMap().entrySet().removeIf(e -> unwantedFields.contains(e.getKey()));
        before.validate();
    }

    @Override
    public DictFiller makePureDictFiller() {
        return DummyFiller.INSTANCE;
    }
}
