package ru.yandex.direct.useractionlog.writer.generator;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

interface Group {

    /**
     * Объект может отсутствовать в Map, а может быть равен null. Хочется отличать эти два случая.
     * <p>
     * {@link java.util.Optional} не подходит, так как не позволяет хранить null.
     * <p>
     * Если объекта нет в ассоциативном массиве, то вместо него возвращается NOTHING. В таком случае можно сравнивать
     * два объекта обычным {@link Objects#equals}.
     * <p>
     * Очевидно, что
     * <code>Object.equals(NOTHING, null) == false<code>,
     * <code>Object.equals(NOTHING, 123) == false</code>,
     * <code>Object.equals(null, 123) == false</code>,
     * но при этом <code>Object.equals(NOTHING, NOTHING) == true<code>.
     */
    Object NOTHING = new Object();

    List<Object> extract(Map<String, String> fieldMap);

    Collection<String> getNames();
}
