package ru.yandex.direct.useractionlog.writer.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import com.google.common.collect.ImmutableList;

class GroupAsIs implements Group {

    private final ImmutableList<String> fieldNames;

    GroupAsIs(ImmutableList<String> fieldNames) {
        this.fieldNames = fieldNames;
    }

    @Override
    public List<Object> extract(Map<String, String> fieldMap) {
        // Несмотря на то, что ImmutableList.Builder вписался бы сюда,
        // он, как и Optional, не позволяет добавить null.
        List<Object> result = new ArrayList<>(fieldNames.size());
        for (String fieldName : fieldNames) {
            if (fieldMap.containsKey(fieldName)) {
                result.add(fieldMap.get(fieldName));
            } else {
                result.add(NOTHING);
            }
        }
        return result;
    }

    @Override
    public Collection<String> getNames() {
        return fieldNames;
    }
}
