package ru.yandex.direct.useractionlog.writer.generator;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.binlog.reader.EnrichedInsertRow;
import ru.yandex.direct.binlog.reader.EnrichedRow;
import ru.yandex.direct.useractionlog.dict.DictDataCategory;
import ru.yandex.direct.useractionlog.dict.DictRequestsFiller;
import ru.yandex.direct.useractionlog.dict.DictResponsesAccessor;
import ru.yandex.direct.useractionlog.dict.FreshDictValuesFiller;
import ru.yandex.direct.useractionlog.schema.ObjectPath;

/**
 * Извлечение {@link ObjectPath} из {@link EnrichedRow}.
 */
@ParametersAreNonnullByDefault
interface ObjectPathStrategy extends DictFiller, PureDictFillerFactory {
    /**
     * @return Список колонок в таблице, значения которых обязательно нужны для создания {@link ObjectPath}.
     */
    Collection<String> objectPathColumns();

    /**
     * Гарантируется, что метод не будет вызван, если доступны не все словарные данные, запрошенные в
     * {@link #fillDictRequests(EnrichedRow, DictRequestsFiller)}.
     *
     * @param row                   Событие о создании/изменении/удалении строки в таблице.
     * @param dictResponsesAccessor Словарные данные, запрошенные ранее.
     * @return {@link ObjectPath}, показывающий, какой объект изменился в этом событии.
     */
    ObjectPath extract(EnrichedRow row, DictResponsesAccessor dictResponsesAccessor);

    @Override
    default DictFiller makePureDictFiller() {
        return new DictFiller() {
            @Override
            public void fillDictRequests(EnrichedRow row, DictRequestsFiller dictRequests) {
                if (row instanceof EnrichedInsertRow) {
                    ObjectPathStrategy.this.fillDictRequests(row, dictRequests);
                }
            }

            @Override
            public void fillFreshDictValues(EnrichedRow row, DictResponsesAccessor dictData,
                                            FreshDictValuesFiller freshDictValues) {
                ObjectPathStrategy.this.fillFreshDictValues(row, dictData, freshDictValues);
            }

            @Override
            public Collection<DictDataCategory> provides() {
                return ObjectPathStrategy.this.provides();
            }
        };

    }
}
