package ru.yandex.direct.useractionlog.writer.generator;

import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface PureDictFillerFactory {
    /**
     * Класс, реализующий {@link DictFiller}, может запрашивать словарные данные либо для генерации новых словарных
     * данных, либо для генерации пользовательских логов. Этот метод должен вернуть такой экземпляр {@link DictFiller},
     * который генерирует те же самые словарные данные, что и исходный класс, но запрашивает только те словарные данные,
     * которые необходимы и достаточны для генерации новых словарных данных.
     */
    DictFiller makePureDictFiller();
}
