package ru.yandex.direct.useractionlog.writer.generator;

import java.util.Collection;
import java.util.Collections;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.binlog.reader.EnrichedRow;
import ru.yandex.direct.binlog.reader.MySQLSimpleRowIndexed;
import ru.yandex.direct.useractionlog.ClientId;
import ru.yandex.direct.useractionlog.dict.DictDataCategory;
import ru.yandex.direct.useractionlog.dict.DictResponsesAccessor;
import ru.yandex.direct.useractionlog.dict.FreshDictValuesFiller;
import ru.yandex.direct.useractionlog.schema.ObjectPath;
import ru.yandex.direct.useractionlog.schema.RetargetingConditionId;

import static ru.yandex.direct.dbschema.ppc.Ppc.PPC;

/**
 * ObjectPath для ppc.retargeting_conditions
 */
@ParametersAreNonnullByDefault
public class RetargetingConditionPathStrategy implements ObjectPathStrategy {
    @Override
    public Collection<String> objectPathColumns() {
        return Collections.singleton(PPC.RETARGETING_CONDITIONS.RET_COND_ID.getName());
    }

    @Override
    public ObjectPath extract(EnrichedRow row, DictResponsesAccessor dictResponsesAccessor) {
        MySQLSimpleRowIndexed data = Util.dataForGettingId(row);
        return new ObjectPath.RetargetingConditionPath(
                new ClientId(Util.fieldAsLong(data, PPC.RETARGETING_CONDITIONS.CLIENT_ID)),
                new RetargetingConditionId(Util.fieldAsLong(data, PPC.RETARGETING_CONDITIONS.RET_COND_ID)));
    }

    @Override
    public Collection<DictDataCategory> provides() {
        return Collections.emptyList();
    }

    @Override
    public void fillFreshDictValues(EnrichedRow row, DictResponsesAccessor dictData,
                                    FreshDictValuesFiller freshDictValues) {
        // Каждый кортеж этой таблицы содержит в себе всё, чтобы построить полный путь.
    }
}
