package ru.yandex.direct.useractionlog.writer.generator;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.useractionlog.dict.DictDataCategory;
import ru.yandex.direct.useractionlog.schema.RecordSource;

import static ru.yandex.direct.dbschema.ppc.Ppc.PPC;

/*

SELECT
    row.name AS row_name,
    operation,
    round(count() / 7) AS daily_count,
    formatReadableSize(sum(length(row.value)) / 7) AS daily_size_bytes
FROM binlog_rows
ARRAY JOIN
    row.name,
    row.value
WHERE (date >= '2017-08-14') AND (date <= '2017-08-20') AND (db = 'ppc') AND (table = 'retargeting_conditions')
GROUP BY
    row_name,
    operation
ORDER BY
    row_name ASC,
    operation ASC


-- 10 rows in set. Elapsed: 2.452 sec. Processed 3.33 million rows, 634.25 MB (1.36 million rows/s., 258.64 MB/s.)


┌─row_name───────┬─operation─┬─daily_count─┬─daily_size_bytes─┐
│ ClientID       │    INSERT │         907 │ 6.73 KiB         │
│ condition_desc │    INSERT │         907 │ 265.14 B         │
│ condition_desc │    UPDATE │           3 │ 140.71 B         │
│ condition_json │    INSERT │         907 │ 76.78 KiB        │
│ condition_json │    UPDATE │         201 │ 35.52 KiB        │
│ condition_name │    INSERT │         907 │ 30.81 KiB        │
│ condition_name │    UPDATE │          82 │ 3.86 KiB         │
│ is_deleted     │    INSERT │         907 │ 906.71 B         │
│ is_deleted     │    UPDATE │          76 │ 75.57 B          │
│ modtime        │    INSERT │         907 │ 18.59 KiB        │
│ modtime        │    UPDATE │         334 │ 6.86 KiB         │
│ properties     │    INSERT │         907 │ 243.43 B         │
└────────────────┴───────────┴─────────────┴──────────────────┘

Количество изменений в этой таблице в сутки столь мало, что нет смысла фильтровать в ней какие-либо поля.

 */

@ParametersAreNonnullByDefault
class RetargetingConditionsRowProcessingStrategy extends ModularRowProcessingStrategy {
    RetargetingConditionsRowProcessingStrategy(RecordSource recordSource) {
        super(recordSource, new RetargetingConditionPathStrategy(), new FieldsStrategyChain(
                StringsFromDictStrategy.builder()
                        .withIdField(PPC.RETARGETING_CONDITIONS.RET_COND_ID.getName())
                        .with(DictDataCategory.RETARGETING_CONDITION_NAME,
                                PPC.RETARGETING_CONDITIONS.CONDITION_NAME.getName())
                        .build(),
                DeduplicationFieldsStrategy.builder().build()));
    }
}
