package ru.yandex.direct.useractionlog.writer.generator;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableMap;

import ru.yandex.direct.useractionlog.schema.RecordSource;

import static ru.yandex.direct.dbschema.ppc.Ppc.PPC;

/**
 * Обработчик логов по умолчанию.
 */
@ParametersAreNonnullByDefault
public class RowProcessingDefaults {
    private RowProcessingDefaults() {
    }

    public static RowProcessingStrategyTableSwitch defaultRowToActionLog(RecordSource recordSource) {
        return new RowProcessingStrategyTableSwitch(rowProcessingStrategyMap(recordSource));
    }

    /**
     * Обработчик, агрегирующий в себе все другие обработчики. Если из какого-то EnrichedRow можно извлечь
     * пользовательские логи - он их должен извлечь.
     */
    public static ImmutableMap<String, RowProcessingStrategy> rowProcessingStrategyMap(RecordSource recordSource) {
        return ImmutableMap.<String, RowProcessingStrategy>builder()
                .put(PPC.BANNERS.getName(), new AdRowProcessingStrategy(recordSource))
                .put(PPC.CAMP_OPTIONS.getName(), new CampOptionsRowProcessingStrategy(recordSource))
                .put(PPC.CAMPAIGNS.getName(), new CampaignRowProcessingStrategy(recordSource))
                .put(PPC.CLIENTS.getName(), new ClientRowProcessingStrategy(recordSource))
                .put(PPC.CLIENTS_OPTIONS.getName(), new ClientRowProcessingStrategy(recordSource))
                .put(PPC.DEMOGRAPHY_MULTIPLIER_VALUES.getName(), new HierarchicalMultipliersStrategy(recordSource))
                .put(PPC.GEO_MULTIPLIER_VALUES.getName(), new HierarchicalMultipliersStrategy(recordSource))
                .put(PPC.HIERARCHICAL_MULTIPLIERS.getName(), new HierarchicalMultipliersStrategy(recordSource))
                .put(PPC.PHRASES.getName(), new AdGroupRowProcessingStrategy(recordSource))
                .put(PPC.RETARGETING_CONDITIONS.getName(),
                        new RetargetingConditionsRowProcessingStrategy(recordSource))
                .put(PPC.RETARGETING_MULTIPLIER_VALUES.getName(), new HierarchicalMultipliersStrategy(recordSource))
                .put(PPC.BIDS_BASE.getName(), new BidBaseRowProcessingStrategy(recordSource))
                .build();
    }
}
