package ru.yandex.direct.useractionlog.writer.generator;

import java.util.List;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.binlog.reader.EnrichedRow;
import ru.yandex.direct.useractionlog.dict.DictResponsesAccessor;
import ru.yandex.direct.useractionlog.schema.ActionLogRecord;

/**
 * Генерация списка {@link ActionLogRecord} для отдельно события вставки/изменения/удаления записи в таблице.
 * Разделено на стадии ради эффективной работы со словарными данными.
 */
@ParametersAreNonnullByDefault
public interface RowProcessingStrategy extends DictFiller, PureDictFillerFactory {
    /**
     * Получить список записей в таблицу пользовательских логов.
     *
     * @param row                   Событие об создании/изменении/удалении записи в таблице
     * @param dictResponsesAccessor Словарные данные, запрошенные ранее.
     * @return Список записей в таблицу пользовательских логов, который не подлежит дальнейшей модификации перед
     * записью.
     */
    @Nonnull
    List<ActionLogRecord> processEvent(EnrichedRow row, DictResponsesAccessor dictResponsesAccessor);
}
