package ru.yandex.direct.useractionlog.reader;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.TranslatableException;

/**
 * Сообщение об ошибке работы с базой данных. Погружать пользователя в подробности не следует.
 */
@ParametersAreNonnullByDefault
public class TranslatableDatabaseException extends TranslatableException {
    public TranslatableDatabaseException(boolean isTemporary, Throwable ex) {
        // https://tech.yandex.ru/direct/doc/ref-v5/concepts/errors-list-docpage/
        super(ex, isTemporary ? 1000 : 1002, UserActionLogTranslations.INSTANCE.databaseError(), null);
    }
}
