package ru.yandex.direct.useractionlog.reader.generator;

import java.util.Collection;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.useractionlog.reader.model.OutputCategory;

@ParametersAreNonnullByDefault
public abstract class AbstractForwardLogRecordGenerator implements LogRecordGenerator {
    private final LogRecordGenerator forward;

    public AbstractForwardLogRecordGenerator(LogRecordGenerator forward) {
        this.forward = forward;
    }

    @Override
    public Map<String, Collection<FieldKeyValue>> getSupportedActionLogRecordTypeToFields() {
        return forward.getSupportedActionLogRecordTypeToFields();
    }

    @Override
    public Map<String, Collection<FieldKeyValue>> getActionLogRecordTypeToFields(
            Collection<OutputCategory> categories) {
        return forward.getActionLogRecordTypeToFields(categories);
    }
}
