package ru.yandex.direct.useractionlog.reader.generator;

import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLNonNull;

import ru.yandex.direct.useractionlog.AdGroupId;
import ru.yandex.direct.useractionlog.CampaignId;
import ru.yandex.direct.useractionlog.ClientId;
import ru.yandex.direct.useractionlog.reader.model.LogEvent;
import ru.yandex.direct.useractionlog.reader.model.MultiAdGroupEvent;
import ru.yandex.direct.useractionlog.reader.model.OutputCategory;

@ParametersAreNonnullByDefault
public class AdGroupsRegionsEvent implements LogEvent, MultiAdGroupEvent {
    private final ClientId clientId;
    private final CampaignId campaignId;
    private final List<AdGroupId> adGroupIds;
    private final List<Integer> oldRegions;
    private final List<Integer> newRegions;

    AdGroupsRegionsEvent(ClientId clientId, CampaignId campaignId, List<AdGroupId> adGroupIds,
                         List<Integer> oldRegions, List<Integer> newRegions) {
        this.clientId = clientId;
        this.campaignId = campaignId;
        this.adGroupIds = adGroupIds;
        this.oldRegions = oldRegions;
        this.newRegions = newRegions;
    }

    @Override
    public @GraphQLNonNull
    long getClientId() {
        return clientId.toLong();
    }

    @Override
    public @GraphQLNonNull
    long getCampaignId() {
        return campaignId.toLong();
    }

    @Override
    public @GraphQLNonNull
    List<Long> getAdGroupIds() {
        return adGroupIds.stream().map(AdGroupId::toLong).collect(Collectors.toList());
    }

    @Nonnull
    public @GraphQLNonNull
    List<Integer> getOldRegions() {
        return oldRegions;
    }

    @Nonnull
    public @GraphQLNonNull
    List<Integer> getNewRegions() {
        return newRegions;
    }

    @Nonnull
    @Override
    public @GraphQLNonNull
    OutputCategory getCategory() {
        return OutputCategory.ADGROUP_REGIONS;
    }
}
