package ru.yandex.direct.useractionlog.reader.generator;

enum BoolTransition {
    SET_TO_TRUE(false, true),
    SET_TO_FALSE(true, false),
    UNCHANGED_TRUE(true, true),
    UNCHANGED_FALSE(false, false);

    final boolean oldValue;
    final boolean newValue;
    final boolean isChange;

    BoolTransition(boolean oldValue, boolean newValue) {
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.isChange = oldValue != newValue;
    }

    static BoolTransition get(boolean oldValue, boolean newValue) {
        if (oldValue == newValue) {
            return newValue ? UNCHANGED_TRUE : UNCHANGED_FALSE;
        } else {
            return newValue ? SET_TO_TRUE : SET_TO_FALSE;
        }
    }
}
