package ru.yandex.direct.useractionlog.reader.generator;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLNonNull;

import ru.yandex.direct.useractionlog.CampaignId;
import ru.yandex.direct.useractionlog.ClientId;
import ru.yandex.direct.useractionlog.reader.model.CampaignEvent;
import ru.yandex.direct.useractionlog.reader.model.LogEvent;
import ru.yandex.direct.useractionlog.reader.model.OutputCategory;

@ParametersAreNonnullByDefault
public class CampaignRestrictFrequencyEvent implements LogEvent, CampaignEvent {
    private final ClientId clientId;
    private final CampaignId campaignId;
    private final RestrictFrequencyView oldRestrictFrequency;
    private final RestrictFrequencyView newRestrictFrequency;

    CampaignRestrictFrequencyEvent(ClientId clientId, CampaignId campaignId,
                                   RestrictFrequencyView oldRestrictFrequency,
                                   RestrictFrequencyView newRestrictFrequency) {
        this.clientId = clientId;
        this.campaignId = campaignId;
        this.oldRestrictFrequency = oldRestrictFrequency;
        this.newRestrictFrequency = newRestrictFrequency;
    }

    @GraphQLNonNull
    public RestrictFrequencyView getOldRestrictFrequency() {
        return oldRestrictFrequency;
    }

    @GraphQLNonNull
    public RestrictFrequencyView getNewRestrictFrequency() {
        return newRestrictFrequency;
    }

    @Override
    public @GraphQLNonNull
    long getClientId() {
        return clientId.toLong();
    }

    @Override
    public @GraphQLNonNull
    long getCampaignId() {
        return campaignId.toLong();
    }

    @Nonnull
    @Override
    public @GraphQLNonNull
    OutputCategory getCategory() {
        return OutputCategory.CAMPAIGN_RESTRICT_FREQUENCY;
    }
}
