package ru.yandex.direct.useractionlog.reader.generator;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.useractionlog.reader.model.OutputCategory;

@ParametersAreNonnullByDefault
public abstract class DefaultRecordGenerator implements LogRecordGenerator {
    protected abstract Map<OutputCategory, String> getTableByCategory();

    protected abstract Map<OutputCategory, Collection<FieldKeyValue>> getFieldsValuesByCategory();

    @Override
    public Map<String, Collection<FieldKeyValue>> getSupportedActionLogRecordTypeToFields() {
        return getActionLogRecordTypeToFields(getTableByCategory().keySet());
    }

    @Override
    public Map<String, Collection<FieldKeyValue>> getActionLogRecordTypeToFields(
            Collection<OutputCategory> categories) {
        Map<OutputCategory, String> tableByCategory = getTableByCategory();
        Map<OutputCategory, Collection<FieldKeyValue>> fieldsValuesByCategory = getFieldsValuesByCategory();

        Map<String, Collection<FieldKeyValue>> result = new HashMap<>();
        for (OutputCategory category : categories) {
            if (tableByCategory.containsKey(category)) {
                String table = tableByCategory.get(category);
                result.putIfAbsent(table, new HashSet<>());
                result.get(table).addAll(fieldsValuesByCategory.get(category));
            }
        }
        return result;
    }
}
