package ru.yandex.direct.useractionlog.reader.generator;

import java.util.Objects;
import java.util.Optional;

import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class FieldKeyValue {
    private String key;
    private Optional<String> value;

    private FieldKeyValue(String key, Optional<String> value) {
        this.key = key;
        this.value = value;
    }

    public String getKey() {
        return key;
    }

    public Optional<String> getValue() {
        return value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FieldKeyValue that = (FieldKeyValue) o;
        return Objects.equals(key, that.key) &&
                Objects.equals(value, that.value);
    }

    @Override
    public int hashCode() {

        return Objects.hash(key, value);
    }

    /**
     * @param key   Название колонки в oldFields/newFields, наличие которой свидетельствует о соответствии некоторому
     *              условию.
     * @param value Значение колонки в oldFields/newFields, которое свидетельствует о наличии события. Если указать
     *              отсутствие значения, то значение игнорируется, соответствие устанавливается только по наличию key.
     */
    public static FieldKeyValue of(String key, Optional<String> value) {
        return new FieldKeyValue(key, value);
    }
}
