package ru.yandex.direct.useractionlog.reader.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.PeekingIterator;

import ru.yandex.direct.useractionlog.reader.model.LogRecord;
import ru.yandex.direct.useractionlog.reader.model.OutputCategory;
import ru.yandex.direct.useractionlog.schema.ActionLogRecordWithStats;

@ParametersAreNonnullByDefault
public class FilterCategories implements LogRecordGenerator {
    private final LogRecordGenerator logRecordGenerator;
    private final ImmutableSet<OutputCategory> filterCategories;

    public FilterCategories(LogRecordGenerator logRecordGenerator, Collection<OutputCategory> categories) {
        this.logRecordGenerator = logRecordGenerator;
        this.filterCategories = ImmutableSet.copyOf(categories);
    }

    @Override
    public List<LogRecord> offer(PeekingIterator<ActionLogRecordWithStats> recordIter) {
        List<LogRecord> result = new ArrayList<>();
        for (LogRecord record : logRecordGenerator.offer(recordIter)) {
            if (filterCategories.contains(record.getEvent().getCategory())) {
                result.add(record);
            }
        }
        return result;
    }

    @Override
    public Map<String, Collection<FieldKeyValue>> getSupportedActionLogRecordTypeToFields() {
        return logRecordGenerator.getSupportedActionLogRecordTypeToFields();
    }

    @Override
    public Map<String, Collection<FieldKeyValue>> getActionLogRecordTypeToFields(
            Collection<OutputCategory> categories) {
        return logRecordGenerator.getActionLogRecordTypeToFields(
                categories.stream().filter(filterCategories::contains).collect(Collectors.toSet()));
    }
}
