package ru.yandex.direct.useractionlog.reader.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.PeekingIterator;

import ru.yandex.direct.useractionlog.ChangeSource;
import ru.yandex.direct.useractionlog.reader.model.LogRecord;
import ru.yandex.direct.useractionlog.reader.model.OutputCategory;
import ru.yandex.direct.useractionlog.schema.ActionLogRecordWithStats;

@ParametersAreNonnullByDefault
public class FilterChangeSource implements LogRecordGenerator {
    private final LogRecordGenerator logRecordGenerator;
    private final ImmutableSet<ChangeSource> filterChangeSource;

    public FilterChangeSource(LogRecordGenerator logRecordGenerator,
                              Collection<ChangeSource> filterChangeSource) {
        this.logRecordGenerator = logRecordGenerator;
        this.filterChangeSource = ImmutableSet.copyOf(filterChangeSource);
    }

    @Override
    public List<LogRecord> offer(PeekingIterator<ActionLogRecordWithStats> recordIter) {
        List<LogRecord> result = new ArrayList<>();
        for (LogRecord record : logRecordGenerator.offer(recordIter)) {
            if (filterChangeSource.contains(record.getChangeSource())) {
                result.add(record);
            }
        }
        return result;
    }

    @Override
    public Map<String, Collection<FieldKeyValue>> getSupportedActionLogRecordTypeToFields() {
        return logRecordGenerator.getSupportedActionLogRecordTypeToFields();
    }

    @Override
    public Map<String, Collection<FieldKeyValue>> getActionLogRecordTypeToFields(Collection<OutputCategory> categories) {
        return logRecordGenerator.getActionLogRecordTypeToFields(categories);
    }
}
