package ru.yandex.direct.useractionlog.reader.generator;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.PeekingIterator;

import ru.yandex.direct.useractionlog.reader.model.LogRecord;
import ru.yandex.direct.useractionlog.reader.model.OutputCategory;
import ru.yandex.direct.useractionlog.schema.ActionLogRecordWithStats;

@ParametersAreNonnullByDefault
public interface LogRecordGenerator {
    List<LogRecord> offer(PeekingIterator<ActionLogRecordWithStats> recordIter);

    Map<String, Collection<FieldKeyValue>> getSupportedActionLogRecordTypeToFields();

    Map<String, Collection<FieldKeyValue>> getActionLogRecordTypeToFields(Collection<OutputCategory> categories);
}
