package ru.yandex.direct.useractionlog.reader.generator;

import java.util.Objects;

import io.leangen.graphql.annotations.GraphQLNonNull;

public class RestrictFrequencyView {
    private final int value;
    private final int reset;

    RestrictFrequencyView(int value, int reset) {
        this.value = value;
        this.reset = reset;
    }

    @GraphQLNonNull
    public int getValue() {
        return value;
    }

    @GraphQLNonNull
    public int getReset() {
        return reset;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RestrictFrequencyView)) {
            return false;
        }
        RestrictFrequencyView that = (RestrictFrequencyView) o;
        return value == that.value &&
                reset == that.reset;
    }

    @Override
    public int hashCode() {
        return Objects.hash(value, reset);
    }
}
