package ru.yandex.direct.useractionlog.reader.generator;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;

import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
class RunOnce<T> implements Consumer<RunOnce.Visitor<T>> {
    private final T owner;
    private final Set<Visitor<T>> executedExtractors = new HashSet<>();

    public RunOnce(T owner) {
        this.owner = owner;
    }

    @Override
    public void accept(Visitor<T> visitor) {
        if (!executedExtractors.contains(visitor)) {
            visitor.visitOnce(owner, this);
            executedExtractors.add(visitor);
        }
    }

    @FunctionalInterface
    interface Visitor<T> {
        void visitOnce(T owner, Consumer<Visitor<T>> visitAnotherOne);
    }
}
