package ru.yandex.direct.useractionlog.reader.generator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import javax.annotation.Nullable;

import ru.yandex.direct.useractionlog.ClientId;
import ru.yandex.direct.useractionlog.reader.model.LogEvent;
import ru.yandex.direct.useractionlog.schema.ActionLogRecord;
import ru.yandex.direct.useractionlog.schema.ObjectPath;

class SingleRecordMetaData {
    private final ClientId clientId;
    private final Map<String, String> beforeFields;
    private final Map<String, String> afterFields;
    private final ActionLogRecord record;
    private final List<LogEvent> events;

    SingleRecordMetaData(ActionLogRecord record) {
        this.events = new ArrayList<>();
        this.record = record;
        ObjectPath.CampaignPath path = (ObjectPath.CampaignPath) record.getPath();
        this.clientId = path.getClientId();
        this.beforeFields = Collections.unmodifiableMap(record.getOldFields().toMap());
        this.afterFields = Collections.unmodifiableMap(record.getNewFields().toMap());
    }

    public List<LogEvent> getEvents() {
        return events;
    }

    public Map<String, String> getBeforeFields() {
        return beforeFields;
    }

    public Map<String, String> getAfterFields() {
        return afterFields;
    }

    public ActionLogRecord getRecord() {
        return record;
    }

    void addEvent(LogEvent event) {
        events.add(event);
    }

    @Nullable
    public String getFromAfterOrBefore(String key) {
        if (getAfterFields().containsKey(key)) {
            return getAfterFields().get(key);
        } else {
            return getBeforeFields().get(key);
        }
    }

    @Nullable
    public String getFromBeforeOrAfter(String key) {
        if (getBeforeFields().containsKey(key)) {
            return getBeforeFields().get(key);
        } else {
            return getAfterFields().get(key);
        }
    }

    public ClientId getClientId() {
        return clientId;
    }
}
