package ru.yandex.direct.useractionlog.reader.generator;

import java.math.BigDecimal;

import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.campaign.model.CampaignsPlatform;
import ru.yandex.direct.grid.model.campaign.GdiCampaignOptsStrategyName;
import ru.yandex.direct.grid.model.campaign.GdiCampaignStrategyGroup;
import ru.yandex.direct.grid.model.campaign.GdiCampaignStrategyName;
import ru.yandex.direct.grid.model.campaign.GdiDayBudgetShowMode;

/**
 * Простейшая реализация {@link GdiCampaignStrategyGroup}.
 */
class StrategyGroupImpl implements GdiCampaignStrategyGroup {
    private BigDecimal dayBudget;
    private GdiDayBudgetShowMode dayBudgetShowMode;
    private CampaignsPlatform platform;
    private GdiCampaignStrategyName strategyName;
    private GdiCampaignOptsStrategyName optsStrategyName;
    private String strategyData;
    private CampaignType type;

    @Override
    public BigDecimal getDayBudget() {
        return dayBudget;
    }

    @Override
    public void setDayBudget(BigDecimal dayBudget) {
        this.dayBudget = dayBudget;
    }

    @Override
    public GdiCampaignStrategyGroup withDayBudget(BigDecimal dayBudget) {
        setDayBudget(dayBudget);
        return this;
    }

    @Override
    public GdiDayBudgetShowMode getDayBudgetShowMode() {
        return dayBudgetShowMode;
    }

    @Override
    public void setDayBudgetShowMode(GdiDayBudgetShowMode dayBudgetShowMode) {
        this.dayBudgetShowMode = dayBudgetShowMode;
    }

    @Override
    public GdiCampaignStrategyGroup withDayBudgetShowMode(GdiDayBudgetShowMode dayBudgetShowMode) {
        setDayBudgetShowMode(dayBudgetShowMode);
        return this;
    }

    @Override
    public CampaignsPlatform getPlatform() {
        return platform;
    }

    @Override
    public void setPlatform(CampaignsPlatform platform) {
        this.platform = platform;
    }

    @Override
    public GdiCampaignStrategyGroup withPlatform(CampaignsPlatform platform) {
        setPlatform(platform);
        return this;
    }

    @Override
    public GdiCampaignStrategyName getStrategyName() {
        return strategyName;
    }

    @Override
    public void setStrategyName(GdiCampaignStrategyName strategyName) {
        this.strategyName = strategyName;
    }

    @Override
    public GdiCampaignStrategyGroup withStrategyName(GdiCampaignStrategyName strategyName) {
        setStrategyName(strategyName);
        return this;
    }

    @Override
    public String getStrategyData() {
        return strategyData;
    }

    @Override
    public void setStrategyData(String strategyData) {
        this.strategyData = strategyData;
    }

    @Override
    public GdiCampaignStrategyGroup withStrategyData(String strategyData) {
        setStrategyData(strategyData);
        return this;
    }

    @Override
    public CampaignType getType() {
        return type;
    }

    @Override
    public void setType(CampaignType type) {
        this.type = type;
    }

    @Override
    public GdiCampaignStrategyGroup withType(CampaignType type) {
        setType(type);
        return this;
    }

    @Override
    public GdiCampaignOptsStrategyName getOptsStrategyName() {
        return optsStrategyName;
    }

    @Override
    public void setOptsStrategyName(GdiCampaignOptsStrategyName optsStrategyName) {
        this.optsStrategyName = optsStrategyName;
    }

    @Override
    public StrategyGroupImpl withOptsStrategyName(GdiCampaignOptsStrategyName optsStrategyName) {
        setOptsStrategyName(optsStrategyName);
        return this;
    }
}
