package ru.yandex.direct.useractionlog.reader.model

import io.leangen.graphql.annotations.GraphQLNonNull
import ru.yandex.direct.core.entity.bids.service.BidBaseOpt
import ru.yandex.direct.core.entity.relevancematch.model.RelevanceMatchCategory
import javax.annotation.Nonnull

data class AdGroupImpressionConditionEvent(private val adGroupId: Long,
                                           private val campaignId: Long,
                                           private val clientId: Long,
                                           val oldState: @GraphQLNonNull EventState,
                                           val newState: @GraphQLNonNull EventState) : LogEvent, AdGroupEvent {

    data class EventState(val opts: @GraphQLNonNull Set<BidBaseOpt>, val categories: @GraphQLNonNull Set<RelevanceMatchCategory>)

    override fun getClientId(): @GraphQLNonNull Long = clientId

    override fun getCampaignId(): @GraphQLNonNull Long = campaignId

    override fun getAdGroupId(): @GraphQLNonNull Long = adGroupId

    @Nonnull
    override fun getCategory(): @GraphQLNonNull OutputCategory = OutputCategory.ADGROUP_IMPRESSION_CONDITION
}
