package ru.yandex.direct.useractionlog.reader.model;

import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLNonNull;

import ru.yandex.direct.useractionlog.AdGroupId;
import ru.yandex.direct.useractionlog.CampaignId;
import ru.yandex.direct.useractionlog.ClientId;
import ru.yandex.direct.useractionlog.schema.AdId;

@ParametersAreNonnullByDefault
public class BannersEvent implements LogEvent, MultiAdEvent {
    private final ClientId clientId;
    private final CampaignId campaignId;
    private final AdGroupId adGroupId;
    private final List<AdId> adIds;
    private final OutputCategory category;

    public BannersEvent(ClientId clientId, CampaignId campaignId, AdGroupId adGroupId,
                        List<AdId> adIds, OutputCategory category) {
        this.clientId = clientId;
        this.campaignId = campaignId;
        this.adGroupId = adGroupId;
        this.adIds = adIds;
        this.category = category;
    }

    @Override
    public @GraphQLNonNull
    long getClientId() {
        return clientId.toLong();
    }

    @Override
    public @GraphQLNonNull
    long getCampaignId() {
        return campaignId.toLong();
    }

    /**
     * Не помечен {@link GraphQLNonNull} потому, что это будет конфликтовать с корректировками ставок,
     * где идентификатор группы опциональный.
     */
    @Nullable
    @Override
    public Long getAdGroupId() {
        return adGroupId.toLong();
    }

    @Nonnull
    @Override
    public @GraphQLNonNull
    OutputCategory getCategory() {
        return category;
    }

    public @GraphQLNonNull
    List<Long> getAdIds() {
        return adIds.stream().map(AdId::toLong).collect(Collectors.toList());
    }
}
