package ru.yandex.direct.useractionlog.reader.model;

import java.util.Objects;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLNonNull;

@ParametersAreNonnullByDefault
public class BroadMatchView {
    private final boolean flag;
    @Nullable
    private final Integer limit;
    private final Long goalId;

    /**
     * @param goalId null - "нет цели", 0 - "все цели", любое другое число - идентификатор конкретной цели
     */
    public BroadMatchView(boolean flag, @Nullable Integer limit, @Nullable Long goalId) {
        this.flag = flag;
        this.limit = limit;
        this.goalId = goalId;
    }

    public @GraphQLNonNull
    boolean isEnabled() {
        return flag;
    }

    public @GraphQLNonNull
    boolean getIsLimitDefined() {
        return isEnabled() && limit != null;
    }

    public @GraphQLNonNull
    int getLimit() {
        return getIsLimitDefined() ? Objects.requireNonNull(limit) : 0;
    }

    /**
     * return null - "нет цели", 0 - "все цели", любое другое число - идентификатор конкретной цели
     */
    @Nullable
    public Long getGoalId() {
        return goalId;
    }

    @Override
    public int hashCode() {
        return Objects.hash(flag, limit, goalId);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BroadMatchView that = (BroadMatchView) o;
        return !flag && !that.flag  // Если оба ДРФ отключены, то неважно, какие там значения
                || flag == that.flag &&
                Objects.equals(limit, that.limit) &&
                Objects.equals(goalId, that.goalId);
    }

}
