package ru.yandex.direct.useractionlog.reader.model;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLNonNull;

import ru.yandex.direct.useractionlog.CampaignId;
import ru.yandex.direct.useractionlog.ClientId;

@ParametersAreNonnullByDefault
@SuppressWarnings("unused")
public class CampaignBroadMatchEvent implements LogEvent, CampaignEvent {
    private final ClientId clientId;
    private final CampaignId campaignId;
    private final BroadMatchView oldBroadMatch;
    private final BroadMatchView newBroadMatch;

    public CampaignBroadMatchEvent(ClientId clientId, CampaignId campaignId,
                                   BroadMatchView oldBroadMatch, BroadMatchView newBroadMatch) {
        this.clientId = clientId;
        this.campaignId = campaignId;
        this.oldBroadMatch = oldBroadMatch;
        this.newBroadMatch = newBroadMatch;
    }

    @Override
    public @GraphQLNonNull
    long getClientId() {
        return clientId.toLong();
    }

    @Override
    public @GraphQLNonNull
    long getCampaignId() {
        return campaignId.toLong();
    }

    @Nonnull
    public @GraphQLNonNull
    BroadMatchView getOldBroadMatch() {
        return oldBroadMatch;
    }

    @Nonnull
    public @GraphQLNonNull
    BroadMatchView getNewBroadMatch() {
        return newBroadMatch;
    }

    @Nonnull
    @Override
    public @GraphQLNonNull
    OutputCategory getCategory() {
        return OutputCategory.CAMPAIGN_BROAD_MATCH;
    }
}
