package ru.yandex.direct.useractionlog.reader.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLNonNull;

import ru.yandex.direct.useractionlog.CampaignId;
import ru.yandex.direct.useractionlog.ClientId;

@ParametersAreNonnullByDefault
public class CampaignListChangeEvent implements LogEvent, CampaignEvent {
    private final List<String> oldList;
    private final List<String> newList;
    private final ClientId clientId;
    private final CampaignId campaignId;
    private final OutputCategory category;

    public CampaignListChangeEvent(ClientId clientId, CampaignId campaignId,
                                   OutputCategory category, Collection<String> old,
                                   Collection<String> removed, Collection<String> added) {
        this.clientId = clientId;
        this.campaignId = campaignId;
        this.category = category;
        this.oldList = new ArrayList<>(old);
        Set<String> removedSet = new HashSet<>(removed);
        this.newList = Stream.concat(old.stream().filter(x -> !removedSet.contains(x)), added.stream())
                .collect(Collectors.toList());
    }

    public CampaignListChangeEvent(ClientId clientId, CampaignId campaignId,
                                   OutputCategory category,
                                   Collection<String> oldCollection, Collection<String> newCollection) {
        this.clientId = clientId;
        this.campaignId = campaignId;
        this.category = category;
        this.oldList = new ArrayList<>(oldCollection);
        this.newList = new ArrayList<>(newCollection);
    }

    @Override
    public @GraphQLNonNull
    long getClientId() {
        return clientId.toLong();
    }

    @Override
    public @GraphQLNonNull
    long getCampaignId() {
        return campaignId.toLong();
    }

    @Nonnull
    public @GraphQLNonNull
    List<String> getOldList() {
        return oldList;
    }

    @Nonnull
    public @GraphQLNonNull
    List<String> getNewList() {
        return newList;
    }

    @Nonnull
    @Override
    public @GraphQLNonNull
    OutputCategory getCategory() {
        return category;
    }
}
