package ru.yandex.direct.useractionlog.reader.model;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLNonNull;

import ru.yandex.direct.useractionlog.CampaignId;
import ru.yandex.direct.useractionlog.ClientId;

@ParametersAreNonnullByDefault
public class CampaignNetworkEvent implements LogEvent, CampaignEvent {
    private final ClientId clientId;
    private final CampaignId campaignId;
    private final NetworkView oldNetwork;
    private final NetworkView newNetwork;

    public CampaignNetworkEvent(ClientId clientId, CampaignId campaignId, NetworkView oldNetwork,
                                NetworkView newNetwork) {
        this.clientId = clientId;
        this.campaignId = campaignId;
        this.oldNetwork = oldNetwork;
        this.newNetwork = newNetwork;
    }

    @Override
    public @GraphQLNonNull
    long getClientId() {
        return clientId.toLong();
    }

    @Override
    public @GraphQLNonNull
    long getCampaignId() {
        return campaignId.toLong();
    }

    @Nonnull
    public @GraphQLNonNull
    NetworkView getOldNetwork() {
        return oldNetwork;
    }

    @Nonnull
    public @GraphQLNonNull
    NetworkView getNewNetwork() {
        return newNetwork;
    }

    @Nonnull
    @Override
    public @GraphQLNonNull
    OutputCategory getCategory() {
        return OutputCategory.CAMPAIGN_NETWORK;
    }
}
