package ru.yandex.direct.useractionlog.reader.model;

import java.util.List;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLNonNull;

import ru.yandex.direct.useractionlog.CampaignId;
import ru.yandex.direct.useractionlog.ClientId;

@ParametersAreNonnullByDefault
public class CampaignRegionsEvent implements LogEvent, CampaignEvent {
    private final ClientId clientId;
    private final CampaignId campaignId;
    private final List<Integer> oldRegions;
    private final List<Integer> newRegions;

    public CampaignRegionsEvent(ClientId clientId, CampaignId campaignId, List<Integer> oldRegions,
                                List<Integer> newRegions) {
        this.clientId = clientId;
        this.campaignId = campaignId;
        this.oldRegions = oldRegions;
        this.newRegions = newRegions;
    }

    @Override
    public @GraphQLNonNull
    long getClientId() {
        return clientId.toLong();
    }

    @Override
    public @GraphQLNonNull
    long getCampaignId() {
        return campaignId.toLong();
    }

    @Nonnull
    public @GraphQLNonNull
    List<Integer> getOldRegions() {
        return oldRegions;
    }

    @Nonnull
    public @GraphQLNonNull
    List<Integer> getNewRegions() {
        return newRegions;
    }

    @Nonnull
    @Override
    public @GraphQLNonNull
    OutputCategory getCategory() {
        return OutputCategory.CAMPAIGN_REGIONS;
    }
}
