package ru.yandex.direct.useractionlog.reader.model;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLNonNull;

import ru.yandex.direct.useractionlog.CampaignId;
import ru.yandex.direct.useractionlog.ClientId;

@ParametersAreNonnullByDefault
public class CampaignStatusChangeEvent implements LogEvent, CampaignEvent {
    private final ClientId clientId;
    private final CampaignId campaignId;
    private final OutputCategory category;

    public CampaignStatusChangeEvent(ClientId clientId, CampaignId campaignId, OutputCategory category) {
        this.clientId = clientId;
        this.campaignId = campaignId;
        this.category = category;
    }

    @Override
    public @GraphQLNonNull
    long getClientId() {
        return clientId.toLong();
    }

    @Override
    public @GraphQLNonNull
    long getCampaignId() {
        return campaignId.toLong();
    }

    @Nonnull
    @Override
    public @GraphQLNonNull
    OutputCategory getCategory() {
        return category;
    }
}
