package ru.yandex.direct.useractionlog.reader.model;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLNonNull;

import ru.yandex.direct.currency.CurrencyCode;
import ru.yandex.direct.grid.model.campaign.strategy.GdCampaignFlatStrategy;
import ru.yandex.direct.useractionlog.CampaignId;
import ru.yandex.direct.useractionlog.ClientId;

@ParametersAreNonnullByDefault
public class CampaignStrategyEvent implements LogEvent, CampaignEvent {
    private final ClientId clientId;
    private final CampaignId campaignId;
    private final CurrencyCode currencyCode;
    private final GdCampaignFlatStrategy oldFlatStrategy;
    private final GdCampaignFlatStrategy newFlatStrategy;
    private final GdCampaignFlatStrategy oldStrategy;
    private final GdCampaignFlatStrategy newStrategy;


    public CampaignStrategyEvent(ClientId clientId, CampaignId campaignId, CurrencyCode currencyCode,
                                 @Nullable GdCampaignFlatStrategy oldFlatStrategy,
                                 GdCampaignFlatStrategy newFlatStrategy,
                                 @Nullable GdCampaignFlatStrategy oldStrategy, GdCampaignFlatStrategy newStrategy) {
        this.clientId = clientId;
        this.campaignId = campaignId;
        this.currencyCode = currencyCode;
        this.oldFlatStrategy = oldFlatStrategy;
        this.newFlatStrategy = newFlatStrategy;
        this.oldStrategy = oldStrategy;
        this.newStrategy = newStrategy;
    }

    @Override
    public @GraphQLNonNull
    long getClientId() {
        return clientId.toLong();
    }

    @Override
    public @GraphQLNonNull
    long getCampaignId() {
        return campaignId.toLong();
    }

    @Nonnull
    @Override
    public @GraphQLNonNull
    OutputCategory getCategory() {
        return OutputCategory.CAMPAIGN_STRATEGY;
    }

    @Nonnull
    public @GraphQLNonNull
    CurrencyCode getCurrencyCode() {
        return currencyCode;
    }

    public GdCampaignFlatStrategy getOldFlatStrategy() {
        return oldFlatStrategy;
    }

    public GdCampaignFlatStrategy getNewFlatStrategy() {
        return newFlatStrategy;
    }

    public GdCampaignFlatStrategy getOldStrategy() {
        return oldStrategy;
    }

    public GdCampaignFlatStrategy getNewStrategy() {
        return newStrategy;
    }
}
