package ru.yandex.direct.useractionlog.reader.model;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLNonNull;

import ru.yandex.direct.useractionlog.CampaignId;
import ru.yandex.direct.useractionlog.ClientId;

@ParametersAreNonnullByDefault
public class CampaignTimeTargetEvent implements LogEvent, CampaignEvent {
    private final ClientId clientId;
    private final CampaignId campaignId;
    private final TimeTargetView oldTimeTarget;
    private final TimeTargetView newTimeTarget;

    public CampaignTimeTargetEvent(ClientId clientId, CampaignId campaignId, TimeTargetView oldTimeTarget,
                                   TimeTargetView newTimeTarget) {
        this.clientId = clientId;
        this.campaignId = campaignId;
        this.oldTimeTarget = oldTimeTarget;
        this.newTimeTarget = newTimeTarget;
    }

    @Override
    public @GraphQLNonNull
    long getClientId() {
        return clientId.toLong();
    }

    @Override
    public @GraphQLNonNull
    long getCampaignId() {
        return campaignId.toLong();
    }

    @Nonnull
    public @GraphQLNonNull
    TimeTargetView getOldTimeTarget() {
        return oldTimeTarget;
    }

    @Nonnull
    public @GraphQLNonNull
    TimeTargetView getNewTimeTarget() {
        return newTimeTarget;
    }

    @Nonnull
    @Override
    public @GraphQLNonNull
    OutputCategory getCategory() {
        return OutputCategory.CAMPAIGN_TIME_TARGET;
    }
}
