package ru.yandex.direct.useractionlog.reader.model;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLNonNull;

import ru.yandex.direct.useractionlog.CampaignId;
import ru.yandex.direct.useractionlog.ClientId;

@ParametersAreNonnullByDefault
public class CampaignValueChangeEvent implements LogEvent, CampaignEvent {
    @Nullable
    private final String oldValue;
    @Nullable
    private final String newValue;
    private final ClientId clientId;
    private final CampaignId campaignId;
    private final OutputCategory category;

    public CampaignValueChangeEvent(ClientId clientId, CampaignId campaignId, OutputCategory category,
                                    @Nullable String oldValue, @Nullable String newValue) {
        this.clientId = clientId;
        this.campaignId = campaignId;
        this.category = category;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    @Override
    public @GraphQLNonNull
    long getClientId() {
        return clientId.toLong();
    }

    @Override
    public @GraphQLNonNull
    long getCampaignId() {
        return campaignId.toLong();
    }

    @Nullable
    public String getOldValue() {
        return oldValue;
    }

    @Nullable
    public String getNewValue() {
        return newValue;
    }

    @Nonnull
    @Override
    public @GraphQLNonNull
    OutputCategory getCategory() {
        return category;
    }
}
