package ru.yandex.direct.useractionlog.reader.model;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableSet;
import io.leangen.graphql.annotations.types.GraphQLType;

/**
 * Мета-категории, используемые в качестве входного аргумента для фильтра по категориям и трансформируемые
 * в {@link OutputCategory}. Являются надмножеством над {@link OutputCategory}, реализованы в виде копипасты
 * потому, что в java не поддерживается наследование enum'ов.
 */
@GraphQLType(name = "Category")
@ParametersAreNonnullByDefault
public enum InputCategory {
    BANNERS_STATUS {
        @Override
        public ImmutableSet<OutputCategory> toOutputCategories() {
            return ImmutableSet.of(
                    OutputCategory.BANNERS_ARCHIVED,
                    OutputCategory.BANNERS_HIDE,
                    OutputCategory.BANNERS_SHOW,
                    OutputCategory.BANNERS_UNARCHIVED);
        }
    },

    CAMPAIGN_STATUS {
        @Override
        public ImmutableSet<OutputCategory> toOutputCategories() {
            return ImmutableSet.of(
                    OutputCategory.CAMPAIGN_ARCHIVED,
                    OutputCategory.CAMPAIGN_HIDE,
                    OutputCategory.CAMPAIGN_SHOW,
                    OutputCategory.CAMPAIGN_UNARCHIVED);
        }
    },

    DEMOGRAPHY_MULTIPLIERS {
        @Override
        public ImmutableSet<OutputCategory> toOutputCategories() {
            return ImmutableSet.of(
                    OutputCategory.ADGROUP_DEMOGRAPHY_MULTIPLIERS,
                    OutputCategory.CAMPAIGN_DEMOGRAPHY_MULTIPLIERS);
        }
    },

    HIERARCHICAL_MULTIPLIERS {
        @Override
        public ImmutableSet<OutputCategory> toOutputCategories() {
            return ImmutableSet.<OutputCategory>builder()
                    .addAll(DEMOGRAPHY_MULTIPLIERS.toOutputCategories())
                    .addAll(MOBILE_MULTIPLIER.toOutputCategories())
                    .addAll(PERFORMANCE_TGO_MULTIPLIER.toOutputCategories())
                    .addAll(RETARGETING_MULTIPLIERS.toOutputCategories())
                    .addAll(VIDEO_MULTIPLIER.toOutputCategories())
                    .build();
        }
    },

    MOBILE_MULTIPLIER {
        @Override
        public ImmutableSet<OutputCategory> toOutputCategories() {
            return ImmutableSet.of(
                    OutputCategory.ADGROUP_MOBILE_MULTIPLIER,
                    OutputCategory.CAMPAIGN_MOBILE_MULTIPLIER);
        }
    },

    PERFORMANCE_TGO_MULTIPLIER {
        @Override
        public ImmutableSet<OutputCategory> toOutputCategories() {
            return ImmutableSet.of(
                    OutputCategory.ADGROUP_PERFORMANCE_TGO_MULTIPLIER,
                    OutputCategory.CAMPAIGN_PERFORMANCE_TGO_MULTIPLIER);
        }
    },

    REGIONS {
        @Override
        public ImmutableSet<OutputCategory> toOutputCategories() {
            return ImmutableSet.of(
                    OutputCategory.ADGROUP_REGIONS,
                    OutputCategory.CAMPAIGN_REGIONS);
        }
    },

    RETARGETING_MULTIPLIERS {
        @Override
        public ImmutableSet<OutputCategory> toOutputCategories() {
            return ImmutableSet.of(
                    OutputCategory.ADGROUP_RETARGETING_MULTIPLIERS,
                    OutputCategory.CAMPAIGN_RETARGETING_MULTIPLIERS);
        }
    },

    VIDEO_MULTIPLIER {
        @Override
        public ImmutableSet<OutputCategory> toOutputCategories() {
            return ImmutableSet.of(
                    OutputCategory.ADGROUP_VIDEO_MULTIPLIER,
                    OutputCategory.CAMPAIGN_VIDEO_MULTIPLIER);
        }
    },

    ADGROUP_REGIONS,
    ADGROUP_IMPRESSION_CONDITION,
    BANNERS_ARCHIVED,
    BANNERS_HIDE,
    BANNERS_SHOW,
    BANNERS_UNARCHIVED,
    CAMPAIGN_ARCHIVED,
    CAMPAIGN_BROAD_MATCH,
    CAMPAIGN_CREATION,
    CAMPAIGN_DISABLED_DOMAINS,
    CAMPAIGN_DISABLED_IPS,
    CAMPAIGN_DISABLED_SSP,
    CAMPAIGN_EXTENDED_GEOTARGETING,
    CAMPAIGN_AUTO_APPLY_PERMISSIONS,
    CAMPAIGN_FINISH_TIME,
    CAMPAIGN_HIDE,
    CAMPAIGN_MINUS_WORDS,
    CAMPAIGN_NETWORK,
    CAMPAIGN_REGIONS,
    CAMPAIGN_RESTRICT_FREQUENCY,
    CAMPAIGN_SHOW,
    CAMPAIGN_START_TIME,
    CAMPAIGN_STRATEGY,
    CAMPAIGN_TIME_TARGET,
    CAMPAIGN_UNARCHIVED;

    public ImmutableSet<OutputCategory> toOutputCategories() {
        return ImmutableSet.of(OutputCategory.valueOf(name()));
    }
}
