package ru.yandex.direct.useractionlog.reader.model;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLNonNull;

import ru.yandex.direct.useractionlog.ChangeSource;
import ru.yandex.direct.utils.JsonUtils;

/**
 * json-представление одного события
 */
@SuppressWarnings("unused")
@ParametersAreNonnullByDefault
public class LogRecord {
    private final LocalDateTime datetime;
    private final LogEvent event;
    private final String gtid;
    private final ChangeSource changeSource;
    private final Boolean isChangedByRecommendation;

    @Nullable
    private Long uid;
    @Nullable
    private Long operatorClientId;

    public LogRecord(LocalDateTime datetime, @Nullable Long uid, String gtid, LogEvent event,
                     ChangeSource changeSource, Boolean isChangedByRecommendation) {
        this.datetime = datetime;  // expected to be UTC
        this.uid = uid;
        this.gtid = gtid;
        this.event = event;
        this.changeSource = changeSource;
        this.isChangedByRecommendation = isChangedByRecommendation;
    }

    @Nullable
    public Long getUid() {
        return uid;
    }

    public void setUid(@Nullable Long uid) {
        this.uid = uid;
    }

    @Nullable
    public Long getOperatorClientId() {
        return operatorClientId;
    }

    public void setOperatorClientId(@Nullable Long operatorClientId) {
        this.operatorClientId = operatorClientId;
    }

    @Nonnull
    public @GraphQLNonNull
    LocalDateTime getDatetime() {
        return datetime;
    }

    @Nonnull
    public @GraphQLNonNull
    LogEvent getEvent() {
        return event;
    }

    @Nonnull
    public @GraphQLNonNull
    ChangeSource getChangeSource() {
        return changeSource;
    }

    @Nonnull
    public @GraphQLNonNull
    Boolean getIsChangedByRecommendation() {
        return isChangedByRecommendation;
    }

    @Override
    public @GraphQLNonNull
    String toString() {
        return JsonUtils.toJson(this);
    }

    /**
     * Это поле используется только для отладки. Нельзя показывать его всем подряд.
     */
    public String getGtid() {
        return gtid;
    }
}
