package ru.yandex.direct.useractionlog.reader.model;

import java.util.Objects;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLNonNull;

@ParametersAreNonnullByDefault
public class NetworkView {
    private final NetworkViewType type;
    private final int limitPercent;
    private final int priceCoef;
    private final boolean enableCpcHold;

    public NetworkView(NetworkViewType type, int limitPercent, int priceCoef, boolean enableCpcHold) {
        this.type = type;
        this.limitPercent = limitPercent;
        this.priceCoef = priceCoef;
        this.enableCpcHold = enableCpcHold;
    }

    @Nonnull
    public @GraphQLNonNull
    NetworkViewType getType() {
        return type;
    }

    public @GraphQLNonNull
    int getLimitPercent() {
        return limitPercent;
    }

    public @GraphQLNonNull
    int getPriceCoef() {
        return priceCoef;

    }

    public @GraphQLNonNull
    boolean isEnableCpcHold() {
        return enableCpcHold;
    }

    @Override
    public int hashCode() {
        return Objects.hash(type, limitPercent, priceCoef, enableCpcHold);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        NetworkView that = (NetworkView) o;
        return limitPercent == that.limitPercent &&
                priceCoef == that.priceCoef &&
                enableCpcHold == that.enableCpcHold &&
                type == that.type;
    }

}
