package ru.yandex.direct.useractionlog.reader.model;

import java.util.List;
import java.util.Objects;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLNonNull;

import ru.yandex.direct.useractionlog.AdGroupId;
import ru.yandex.direct.useractionlog.CampaignId;
import ru.yandex.direct.useractionlog.ClientId;

@ParametersAreNonnullByDefault
public class RetargetingMultipliersEvent implements LogEvent, AdGroupEvent {
    private final List<RetargetingMultiplierView> oldRetargetingMultipliers;
    private final List<RetargetingMultiplierView> newRetargetingMultipliers;
    private final ClientId clientId;
    private final CampaignId campaignId;
    @Nullable
    private final AdGroupId adGroupId;

    public RetargetingMultipliersEvent(ClientId clientId, CampaignId campaignId, @Nullable AdGroupId adGroupId,
                                       List<RetargetingMultiplierView> oldRetargetingMultipliers,
                                       List<RetargetingMultiplierView> newRetargetingMultipliers) {
        this.clientId = clientId;
        this.campaignId = campaignId;
        this.adGroupId = adGroupId;
        this.oldRetargetingMultipliers = oldRetargetingMultipliers;
        this.newRetargetingMultipliers = newRetargetingMultipliers;
    }

    public @GraphQLNonNull
    List<RetargetingMultiplierView> getOldRetargetingMultipliers() {
        return oldRetargetingMultipliers;
    }

    public @GraphQLNonNull
    List<RetargetingMultiplierView> getNewRetargetingMultipliers() {
        return newRetargetingMultipliers;
    }

    @Override
    public @GraphQLNonNull
    long getClientId() {
        return clientId.toLong();
    }

    @Override
    public @GraphQLNonNull
    long getCampaignId() {
        return campaignId.toLong();
    }

    @Nullable
    @Override
    public Long getAdGroupId() {
        return adGroupId == null ? null : adGroupId.toLong();
    }

    @Nonnull
    @Override
    public @GraphQLNonNull
    OutputCategory getCategory() {
        if (adGroupId == null) {
            return OutputCategory.CAMPAIGN_RETARGETING_MULTIPLIERS;
        } else {
            return OutputCategory.ADGROUP_RETARGETING_MULTIPLIERS;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RetargetingMultipliersEvent that = (RetargetingMultipliersEvent) o;
        return Objects.equals(clientId, that.clientId) &&
                Objects.equals(campaignId, that.campaignId) &&
                Objects.equals(adGroupId, that.adGroupId) &&
                Objects.equals(oldRetargetingMultipliers, that.oldRetargetingMultipliers) &&
                Objects.equals(newRetargetingMultipliers, that.newRetargetingMultipliers);
    }

    @Override
    public int hashCode() {
        return Objects.hash(clientId, campaignId, adGroupId, oldRetargetingMultipliers, newRetargetingMultipliers);
    }

    @ParametersAreNonnullByDefault
    public static class RetargetingMultiplierView {
        private final long retargetingConditionId;
        private final String retargetingConditionName;
        private final int multiplier;

        public RetargetingMultiplierView(long retargetingConditionId, String retargetingConditionName, int multiplier) {
            this.retargetingConditionId = retargetingConditionId;
            this.retargetingConditionName = retargetingConditionName;
            this.multiplier = multiplier;
        }

        public @GraphQLNonNull
        long getRetargetingConditionId() {
            return retargetingConditionId;
        }

        @Nonnull
        public @GraphQLNonNull
        String getRetargetingConditionName() {
            return retargetingConditionName;
        }

        public @GraphQLNonNull
        int getMultiplier() {
            return multiplier;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            RetargetingMultiplierView that = (RetargetingMultiplierView) o;
            return retargetingConditionId == that.retargetingConditionId &&
                    multiplier == that.multiplier &&
                    Objects.equals(retargetingConditionName, that.retargetingConditionName);
        }

        @Override
        public int hashCode() {
            return Objects.hash(retargetingConditionId, retargetingConditionName, multiplier);
        }
    }
}
