package ru.yandex.direct.useractionlog.reader.model;

import java.util.Objects;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLNonNull;

import ru.yandex.direct.useractionlog.AdGroupId;
import ru.yandex.direct.useractionlog.CampaignId;
import ru.yandex.direct.useractionlog.ClientId;

@ParametersAreNonnullByDefault
public class SingleMultiplierEvent implements LogEvent, AdGroupEvent {
    private final int oldMultiplier;
    private final int newMultiplier;
    private final ClientId clientId;
    private final CampaignId campaignId;
    @Nullable
    private final AdGroupId adGroupId;
    private final OutputCategory category;

    public SingleMultiplierEvent(ClientId clientId, CampaignId campaignId, @Nullable AdGroupId adGroupId,
                                 OutputCategory category,
                                 int oldMultiplier, int newMultiplier) {
        this.clientId = clientId;
        this.campaignId = campaignId;
        this.adGroupId = adGroupId;
        this.category = category;
        this.oldMultiplier = oldMultiplier;
        this.newMultiplier = newMultiplier;
    }

    @Override
    public @GraphQLNonNull
    long getClientId() {
        return clientId.toLong();
    }

    @Override
    public @GraphQLNonNull
    long getCampaignId() {
        return campaignId.toLong();
    }

    public @GraphQLNonNull
    int getOldMultiplier() {
        return oldMultiplier;
    }

    public @GraphQLNonNull
    int getNewMultiplier() {
        return newMultiplier;
    }

    @Override
    public int hashCode() {
        return Objects.hash(oldMultiplier, newMultiplier, clientId, campaignId, adGroupId);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SingleMultiplierEvent that = (SingleMultiplierEvent) o;
        return oldMultiplier == that.oldMultiplier &&
                newMultiplier == that.newMultiplier &&
                Objects.equals(clientId, that.clientId) &&
                Objects.equals(campaignId, that.campaignId) &&
                Objects.equals(adGroupId, that.adGroupId);
    }

    @Nonnull
    @Override
    public @GraphQLNonNull
    OutputCategory getCategory() {
        return category;
    }

    @Nullable
    @Override
    public Long getAdGroupId() {
        return adGroupId == null ? null : adGroupId.toLong();
    }
}
