package ru.yandex.direct.useractionlog.reader.model;

import java.util.List;
import java.util.Map;
import java.util.Objects;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLNonNull;

import ru.yandex.direct.libs.timetarget.WeekdayType;

/**
 * Представление для {@link ru.yandex.direct.libs.timetarget.TimeTarget}
 */
@ParametersAreNonnullByDefault
public class TimeTargetView {
    private final long timeZoneId;
    private final Map<WeekdayType, List<Integer>> timeTargetMap;

    public TimeTargetView(long timeZoneId, Map<WeekdayType, List<Integer>> timeTargetMap) {
        this.timeZoneId = timeZoneId;
        this.timeTargetMap = timeTargetMap;
    }

    public long getTimeZoneId() {
        return timeZoneId;
    }

    @Nonnull
    public @GraphQLNonNull
    List<Integer> getSunday() {
        return extractDayArray(WeekdayType.SUNDAY);
    }

    @Nonnull
    public @GraphQLNonNull
    List<Integer> getMonday() {
        return extractDayArray(WeekdayType.MONDAY);
    }

    @Nonnull
    public @GraphQLNonNull
    List<Integer> getTuesday() {
        return extractDayArray(WeekdayType.TUESDAY);
    }

    @Nonnull
    public @GraphQLNonNull
    List<Integer> getWednesday() {
        return extractDayArray(WeekdayType.WEDNESDAY);
    }

    @Nonnull
    public @GraphQLNonNull
    List<Integer> getThursday() {
        return extractDayArray(WeekdayType.THURSDAY);
    }

    @Nonnull
    public @GraphQLNonNull
    List<Integer> getFriday() {
        return extractDayArray(WeekdayType.FRIDAY);
    }

    @Nonnull
    public @GraphQLNonNull
    List<Integer> getSaturday() {
        return extractDayArray(WeekdayType.SATURDAY);
    }

    @Nonnull
    public @GraphQLNonNull
    List<Integer> getHoliday() {
        return extractDayArray(WeekdayType.HOLIDAY);
    }

    @Nonnull
    public @GraphQLNonNull
    List<Integer> getWorkingWeekend() {
        return extractDayArray(WeekdayType.WORKING_WEEKEND);
    }

    private List<Integer> extractDayArray(WeekdayType weekdayType) {
        return Objects.requireNonNull(timeTargetMap.get(weekdayType));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TimeTargetView that = (TimeTargetView) o;
        return timeZoneId == that.timeZoneId &&
                Objects.equals(timeTargetMap, that.timeTargetMap);
    }

    @Override
    public int hashCode() {
        return Objects.hash(timeZoneId, timeTargetMap);
    }
}
