#!/bin/bash
(
    set -e
    set -u

    ulimit -v unlimited

    ch_password="$(< /etc/direct-tokens/clickhouse_user_action_log)"
    ch='clickhouse-client --host ppchouse-alw01f.ppc.yandex.ru --user user_action_log --password '"$ch_password"' --database user_action_log --query'
    journal_dict_tables=(journal_dict_mergetree_{01..14})
    today=$(date --utc +%Y%m%d)
    today_iso=$(date --utc +%Y-%m-%d)
    today_table="journal_dict_mergetree_$(printf %02d $(($(date --utc +%s) / 86400 % 14 + 1)))"


    dst_journal_dict_table=
    for jdt in "${journal_dict_tables[@]}"; do
        if [[ "$today_table" = "$jdt" ]]; then
            dst_journal_dict_table="$jdt"
        fi
    done
    if [[ -z "$dst_journal_dict_table" ]]; then
        echo "Error: wrong dict table $today_table" 1>&2
        exit 1
    fi

    echo '======= BACKUP ======='
    table=user_action_log_state
    echo "$table"
    $ch "create table if not exists backup_${today}_${table} engine = Log as select * from $table"
    table="$dst_journal_dict_table"
    echo "$table"
    $ch "create table if not exists backup_${today}_${table} engine = Log as select * from $table"
    for table in "${journal_dict_tables[@]}"; do
        if [[ "$table" != "$dst_journal_dict_table" ]]; then
            echo "$table"
            $ch "create table if not exists backup_${today}_${table} engine = Log as select * from $table"
        fi
    done

    echo '======= MOVE TO TODAY ======='
    for table in "${journal_dict_tables[@]}"; do
        if [[ "$table" != "$dst_journal_dict_table" ]]; then
            echo "$table"
            $ch "insert into ${dst_journal_dict_table} select * from ${table}"
        else
            echo "Skip table $table"
        fi
    done

    echo '======= CLEAN TABLES ======='
    for table in "${journal_dict_tables[@]}"; do
        if [[ "$table" != "$dst_journal_dict_table" ]]; then
            echo "$table"
            $ch "alter table ${table} drop partition 201803"
            $ch "alter table ${table} drop partition 201804"
            $ch "alter table ${table} drop partition 201805"
        else
            echo "Skip table $table"
        fi
    done


    echo '======= RESULT ======='
    echo 'Sleep 10 seconds. Writer will add new data to journal dict.'
    sleep 10
    echo 'You should see exactly one non-empty journal_dict_mergetree'
    for table in "${journal_dict_tables[@]}"; do
        echo "$table"
        $ch "select count() from ${table}"
    done

    echo '======= DONE ======='
) 2>&1 | tee /var/log/yandex/20180518_merge-journal-dicts.migr.log
