#!/usr/bin/perl

# Иногда по невыясненным причинам user-action-log-writer падает с "gtid_set of dict is greater than gtid_set of log"
# Этот скрипт для того, чтобы устранить симптомы, позволяя процессу двигаться дальше: он выставляет в состоянии для dict такой же gtid_set, как в log. Проверено, что это помогает.
# Предполагается, что тот, кто запускает скрипт, знает, какую проблему он решает и как. Это не "коробочное" решение и может требовать доработок на месте. Если есть вопросы, их можно задать yukaba@ или lena-san@
# Написан на коленке и ad hoc, поэтому есть показания к применению:
#  - dict- и log-состояния различается только набором gtid'ов, т. е. схемы данных одинаковые
#  - в dict больше gtid'ов, чем в log (скрипт не падает, если это не так; нужно смотреть дифф и убеждаться, что всё в порядке)
#  - в обоих состояниях одинаковый набор server_id в списке gtid (в принципе может отсутствовать целый набор, но на практике с таким не сталкивались, поэтому такой случай не обрабатывается)
#  - различается набор gtid только для одного server_id (соображения такие же, как в предыдущем пункте)
# Планов на доработку нет, пока рассчитываем, что перестанет быть нужным с систематическим решением проблемы или переделыванием user-action-log-writer на читалку из logbroker.

# Как пользоваться:
# Запускать на машине с кликхаусом alw с аргументом ppc:N, где N -- номер шарда. Выведет в stdout tsv-строку, которую можно вставить в таблицу user_action_log2.user_action_log_state. Другими словами, сам по себе никак состояние не изменяет.
# В stderr выведет контрольную информацию, например, различающиеся списки gtid'ов и diff текущего и вставляемого состояния.
# Примеры применения:
# # только посмотреть, как поменяется состояние
# ./fix-dict-state,pl ppc:15 >/dev/null
# # поменять состояние
# ./fix-dict-state.pl ppc:15 | tail -1 | clickhouse-client -h sas-eo4jbhwj50dkq0si.db.yandex.net --port 9440 --user user_action_log2 --database user_action_log2 --password "$(cat /etc/direct-tokens/clickhouse_user_action_log2)" -q "INSERT INTO user_action_log2.user_action_log_state FORMAT TSV"

use strict;
use warnings;

use utf8;
use open qw/:std :encoding(UTF-8)/;

use File::Temp 'tempfile';

my $shard = $ARGV[0] || die "no shard given\nusage: $0 ppc:N\n";
print STDERR "$shard\n";
my $dict_state_row = `dbs-sql pr:ppchouse:ppc:shards:1 -q "SELECT * FROM user_action_log2.user_action_log_state WHERE type = 'DICT' and source = '$shard' and date >= '2018-08-17' order by datetime desc limit 1 FORMAT TabSeparated"`;
my $log_state_row = `dbs-sql pr:ppchouse:ppc:shards:1 -q "SELECT * FROM user_action_log2.user_action_log_state WHERE type = 'LOG' and source = '$shard' and date >= '2018-08-17' order by datetime desc limit 1 FORMAT TabSeparated"`;

(my $dict_state = (split /\t/,  $dict_state_row)[4]) =~ s/,/,\n/g;
(my $log_state = (split /\t/,  $log_state_row)[4]) =~ s/,/,\n/g;
(my $dict_gtids_str = $dict_state) =~ s/.*"gtid_set":"(.*)".*/$1/s;
(my $log_gtids_str = $log_state) =~ s/.*"gtid_set":"(.*)".*/$1/s;
#$log_gtids_str =~ s/(1-[0-9]+)[0-9]/${1}0/;
my @dict_gtids = sort split /\s*,\s*/, $dict_gtids_str;
my @log_gtids = sort split /\s*,\s*/, $log_gtids_str;
my %gtid_in_log = map { $_ => 1 } @log_gtids;
my %gtid_in_dict = map { $_ => 1 } @dict_gtids;
my (@dict_differing_gtid_sets) = grep { !$gtid_in_log{$_} } @dict_gtids;
my (@log_differing_gtid_sets) = grep { !$gtid_in_dict{$_} } @log_gtids;
die "too many differing gtid sets\n" if @dict_differing_gtid_sets > 1 || @log_differing_gtid_sets > 1;
die "no differences\n" if @dict_differing_gtid_sets == 0 && @log_differing_gtid_sets == 0;
die "missing entire gtid set, can't handle that\n" if @dict_differing_gtid_sets == 0 || @log_differing_gtid_sets == 0;
my $log_gtid_set = $log_differing_gtid_sets[0];
my $dict_gtid_set = $dict_differing_gtid_sets[0];
print STDERR "old: $dict_gtid_set\nnew: $log_gtid_set\nin dict\n";
my $new_date = `date +%Y-%m-%d`;
my $new_datetime = `date '+%Y-%m-%d %H:%M:%S'`;
chomp $new_date;
chomp $new_datetime;
my $old_date = (split /\t/,  $dict_state_row)[2];
my $old_datetime = (split /\t/,  $dict_state_row)[3];
my $new_dict_state_row = $dict_state_row;
for ($new_dict_state_row) {
    s/\Q$old_datetime\E/$new_datetime/;
    s/\Q$old_date\E/$new_date/;
    s/\Q$dict_gtid_set\E/$log_gtid_set/;
}
my ($fh_old, $fname_old) = tempfile();
my ($fh_new, $fname_new) = tempfile();
print $fh_old $dict_state_row =~ s/,/,\n/gr;
print $fh_new $new_dict_state_row =~ s/,/,\n/gr;
system "diff -u '$fname_old' '$fname_new' 1>&2";
print "$new_dict_state_row";
