#!/bin/bash

NAME=direct-user-action-log-writer
GC_LOG="/var/log/yandex/$NAME.gc.log"
XMX_RAM="4G"
CPU_NUM=8

# wait for unified agent
while ! curl http://localhost:16301/status > /dev/null 2>&1; do sleep 1; done

#fix dir rights
chmod a+w -R /var/log/yandex/

case "$1" in
    dev7)
        JAVA_ADDITIONAL_ARGS=(
            -Ddb_config=zk:///direct/np/db-config/db-config.dev7.json
        )
        ;;
    devtest)
        JAVA_ADDITIONAL_ARGS=(
            -Ddb_config=zk:///direct/np/db-config/db-config.devtest.json
        )
        ;;
    testing)
        JAVA_ADDITIONAL_ARGS=(
            -Ddb_config=zk:///direct/np/db-config/db-config.test.json
        )
        ;;
    production)
        JAVA_ADDITIONAL_ARGS=(
            -Ddb_config=zk:///direct/db-config.json
        )
        XMX_RAM="32G"
        CPU_NUM=12
        ;;
esac

JAVA_ADDITIONAL_ARGS+=(
    -Dnetwork_config=zk:///direct/network-config.json
)


JAVA_OPTS=(
    -Xmx"$XMX_RAM"
    -XX:ActiveProcessorCount="$CPU_NUM"
    -Dfile.encoding=UTF-8
    -Djava.net.preferIPv4Stack=false
    -Djava.net.preferIPv6Addresses=true
    -Dsun.net.inetaddr.ttl=60
    -Dsun.net.inetaddr.negative.ttl=0
    -Xlog:gc*=info,safepoint=info,age*=trace:file=$GC_LOG:time,uptime,level,tags:filecount=5,filesize=100M
    -XX:+CrashOnOutOfMemoryError
    -XX:+HeapDumpOnOutOfMemoryError
    -XX:HeapDumpPath=/var/log/yandex/$NAME.hprof
    -Djdk.tls.client.protocols="TLSv1,TLSv1.1,TLSv1.2"
)

JAVA_ARGS=(
    -cp /var/www/$NAME/lib/*:
    -Djava.library.path=/var/www/$NAME/lib
    -Dhealth_checker.enable_cache=true
    -Dlog4j.configurationFile=/etc/direct/$NAME/logging-config/log4j2-deploy.xml
    ru.yandex.direct.useractionlog.writer.UserActionLogTool
    --log-configs-directory /etc/direct/$NAME/logging-config/
)

export DIRECT_ALW_PID="$$"

# если EVENT_BATCH_SIZE и RECORD_BATCH_SIZE не переданы, будут браться значения по умолчанию
sudo -u nobody -H -E /usr/local/yandex-direct-jdk11/bin/java ${JAVA_OPTS[@]} ${JAVA_ADDITIONAL_ARGS[@]} ${JAVA_ARGS[@]} --zk-lock-timeout PT10M run --mysql-server-id 996"$((RANDOM%89+10))" --event-batch-size ${EVENT_BATCH_SIZE:-5000} --event-batch-duration PT30s --binlog-keep-alive-timeout PT120s --record-batch-size ${RECORD_BATCH_SIZE:-50000}
